/*
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
*/
//+------------------------------------------------------------------+
//|                                              Bollinger Bands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Blue
#property indicator_color2 Lime
#property indicator_color3 Blue
//----   Bollinger Bands
#property indicator_style1 4
#property indicator_style2 4
#property indicator_style3 4
//----    --------------------------------------------------------------------------------------------------+
extern int        Bands_Period = 20; //    J2Bollinger Bands
extern double Bands_Deviations = 2.0; //  
extern int           MA_method = 0;   //  
extern int         Bands_Shift = 0;   // c     
extern int Input_Price_Customs = 0;   // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//---- buffers
double UpperBuffer[];
double LowerBuffer[];
double MovingBuffer[];
double SeriesBuffer[];
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| Bollinger Bands initialization function                          | 
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexStyle(1,DRAW_LINE);
//---- 4     
   IndicatorBuffers(4); 
   SetIndexBuffer(0,UpperBuffer );  
   SetIndexBuffer(1,MovingBuffer);
   SetIndexBuffer(2,LowerBuffer );
   SetIndexBuffer(3,SeriesBuffer);
//----   ,       
   int drawbegin=Bands_Period+Bands_Shift; 
   SetIndexDrawBegin(0,drawbegin);
   SetIndexDrawBegin(1,drawbegin);
   SetIndexDrawBegin(2,drawbegin);
//----      
   SetIndexShift (0, Bands_Shift); 
   SetIndexShift (1, Bands_Shift); 
   SetIndexShift (2, Bands_Shift); 
//----        . 
   IndicatorShortName ("Bollinger Bands( Period="+Bands_Period+", Deviations="+Bands_Deviations+")"); 
   SetIndexLabel (0, "Upper Bands"); 
   SetIndexLabel (2, "Lower Bands"); 
   switch(MA_method)
           {
            case  0: SetIndexLabel (1, "JMoving Avereges JSMA ("+Bands_Period+")");break;
            case  1: SetIndexLabel (1, "JMoving Avereges JEMA ("+Bands_Period+")");break;
            case  2: SetIndexLabel (1, "JMoving Avereges JSSMA("+Bands_Period+")");break;
            case  3: SetIndexLabel (1, "JMoving Avereges JLWMA("+Bands_Period+")");break;
            default: SetIndexLabel (1, "JMoving Avereges JSMA ("+Bands_Period+")");
           }
//----          
//----        ======================================================================================+ 
if(Bands_Period<1)   {Alert(" Bands_Period     1 "+ "    " +Bands_Period+ "    1");}//////////|
if(MA_method<0)      {Alert(" MA_method    0  3"   + "    " +MA_method+ "   0");}////////////////|
if(MA_method>3)      {Alert(" MA_method    0  3"   + "    " +MA_method+ "   0");}////////////////|
PriceSeriesAlert(Input_Price_Customs);//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////|
//+========================================================================================================================================================+ 
//----     Bands_Period
if(Bands_Period<1)Bands_Period=1; 
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Bollinger Bands iteration function                               | 
//+------------------------------------------------------------------+
int start()
  {
//----       
if(Bars<=Bands_Period) return(0);
//----+     
double sum,midline,priceswing,deviation;
//----+        
int bar,kk,MaxBarBB,limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
limit=Bars-counted_bars-1; MaxBarBB=Bars-1-Bands_Period;
//----+              
for(bar=limit;bar>=0;bar--)SeriesBuffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
if (limit>MaxBarBB)limit=MaxBarBB;

for(bar=limit;bar>=0;bar--)
     {
      //----+    Moving Avereges
      midline=iMAOnArray(SeriesBuffer,0,Bands_Period,0,MA_method, bar);
      MovingBuffer[bar]=midline;
      
      //---- ר Bollinger Bands
      sum=0.0;
      kk=bar+Bands_Period-1;
      while(kk>=bar)
        {
         priceswing=PriceSeries(Input_Price_Customs,kk)-midline;
         sum+=priceswing*priceswing;
         kk--;
        }
      deviation=Bands_Deviations*MathSqrt(sum/Bands_Period);
      UpperBuffer[bar]=midline+deviation;
      LowerBuffer[bar]=midline-deviation;
      //----
    }
//----
   return(0);
  } 
//+------------------------------------------------------------------+

